import 'package:easy_localization/easy_localization.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:wordpress_app/models/article.dart';
import 'package:wordpress_app/services/app_service.dart';
import 'package:wordpress_app/utils/cached_image.dart';
import 'package:wordpress_app/utils/next_screen.dart';
import 'package:wordpress_app/widgets/video_icon.dart';

import '../blocs/config_bloc.dart';

class FeatureCard extends ConsumerWidget {
  final Article article;
  final String heroTag;
  const FeatureCard({super.key, required this.article, required this.heroTag});

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final configs = ref.read(configBlocProvider).configs!;
    final bool showDateTime = configs.showDateTime;
    return InkWell(
        child: Container(
          margin: const EdgeInsets.all(15),
          child: Stack(
            children: <Widget>[
              Hero(
                tag: heroTag,
                child: Stack(
                  alignment: Alignment.center,
                  children: [
                    Container(
                      width: MediaQuery.of(context).size.width,
                      decoration: BoxDecoration(
                        color: Theme.of(context).colorScheme.shadow,
                        borderRadius: BorderRadius.circular(5),
                      ),
                      child:
                          CustomCacheImage(imageUrl: article.image, radius: 5),
                    ),
                    VideoIcon(
                      article: article,
                      iconSize: 80,
                    )
                  ],
                ),
              ),
              Positioned(
                top: 12,
                right: 12,
                child: Container(
                  padding: const EdgeInsets.symmetric(
                    horizontal: 10,
                    vertical: 6,
                  ),
                  decoration: BoxDecoration(
                    color:
                        Theme.of(context).primaryColor.withValues(alpha: 0.8),
                    borderRadius: BorderRadius.circular(5),
                  ),
                  child: Text('top_news',
                      style: Theme.of(context).textTheme.labelSmall?.copyWith(
                            fontWeight: FontWeight.w600,
                            color: Colors.white,
                            fontSize: 14,
                          )).tr(),
                ),
              ),
              Positioned(
                  bottom: 0,
                  left: 0,
                  right: 0,
                  child: Container(
                    padding: const EdgeInsets.only(
                        left: 15, right: 15, top: 15, bottom: 15),
                    decoration: BoxDecoration(
                        color: Theme.of(context)
                            .colorScheme
                            .shadow
                            .withValues(alpha: 0.3),
                        borderRadius: const BorderRadius.only(
                            bottomLeft: Radius.circular(5),
                            bottomRight: Radius.circular(5))),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppService.getNormalText(article.title!),
                          style: Theme.of(context)
                              .textTheme
                              .titleMedium
                              ?.copyWith(
                                  color: Colors.white,
                                  fontSize: 18,
                                  fontWeight: FontWeight.w600),
                          maxLines: 2,
                          overflow: TextOverflow.ellipsis,
                        ),
                        const SizedBox(
                          height: 5,
                        ),
                        Visibility(
                          visible: showDateTime,
                          child: Row(
                            children: <Widget>[
                              const Icon(CupertinoIcons.time,
                                  size: 16, color: Colors.white),
                              const SizedBox(
                                width: 5,
                              ),
                              Text(AppService.getTime(article.date!, context),
                                  style: Theme.of(context)
                                      .textTheme
                                      .bodyMedium
                                      ?.copyWith(color: Colors.white))
                            ],
                          ),
                        )
                      ],
                    ),
                  )),
            ],
          ),
        ),
        onTap: () =>
            navigateToDetailsScreen(context, article, heroTag, configs));
  }
}
